<?php
require_once("UserAgentUtils.php");
require_once("DetectBrowser.php");
require_once("General.php");

check_path_info();

no_cache();

// In the beginning of the login page - delete any prior authentication cookie
// if there has been one. All flows of login finally arrive here.
deleteAuthCookie();

$LegalBannerTitle = substr(LEGAL_TITLE, 0, 60);
$LegalBannerText = substr(LEGAL_TEXT, 0, 500);

global $nMaxLogoHeight;
global $ICSSessionCookieExpiration;
global $passedIcsScan;

global $snx_relogin;
global $portalpopup_relogin;
	
function isRelogin()
{
	global $snx_relogin;
	global $portalpopup_relogin;
	
	if((isset($snx_relogin) && $snx_relogin) || (isset($snx_relogin) && $portalpopup_relogin))
	{
		return 1;
	}
	
	return 0;
}

if (!isset($nMaxLogoHeight)) {$nMaxLogoHeight = 60;}
$nLegalNoticeSpace = 131 - $nMaxLogoHeight;

// Get available realms
$old_session_id = "";
if (array_key_exists("CPCVPN_SESSION_ID", $_COOKIE))
{
	$old_session_id = trim($_COOKIE["CPCVPN_SESSION_ID"]);
}
else if (array_key_exists("SESSION_ID", $_COOKIE))
{
	$old_session_id = trim($_COOKIE["SESSION_ID"]);
}

//	Get available realms
$availabeRealmsRes_d = getAvailableRealmsResonse($old_session_id, E_SESSION_INITIATOR_PORTAL);
if ($availabeRealmsRes_d == NULL)
{
	internal_error_page();
}

//	Convert to php array
$realmsArr = availableRealmsResponseToArr($availabeRealmsRes_d);

//	No realms were configured for client
if(count($realmsArr) == 0)
{
	realms_configuration_error_page();
}
?>

<html>
    <HEAD>
		<meta name="robots" content="noindex,nofollow">

        <TITLE>
            <?=charset_htmlentities($PortalTitle." - ".SIGN_IN)?>
        </TITLE>
        <?= charset(); ?>

        <link rel="stylesheet" href="../Login/Login.css" type="text/css">
		<script language="JavaScript" src="../Login/utilities.js"></script>
		<script language="JavaScript" src="../Login/JS_RSA.js"></script>
	    <script language="javascript">
			breakOutOfFrames();
			
			var realmsArr = new Array();
			var loginErrorMsg = "<?php echo addslashes(LOGIN_ERROR_MESSAGE); ?>";
			
			<?PHP //this method is the same as the one that is in portal/general.js but general is not available at the login state. ?>
			
			function isRelogin()
			{
				return <?php echo isRelogin(); ?>;
			}
			
			function readOnlyUserNameInput()
			{
				document.getElementById("userName").readOnly = true;
				document.getElementById('userName').style.backgroundColor = "#D4D0C8";
			}
			
			function disableUserNameInput()
			{
				readOnlyUserNameInput();
				document.getElementById("userName").disable = true;
			}
			
			function enableUserNameInput()
			{
				document.getElementById("userName").readOnly = false;
				document.getElementById('userName').style.backgroundColor = "white";
				document.getElementById("userName").disable = false;
			}
			
			function disablePasswordInput()
			{
				document.getElementById("passwordDisplayed").readOnly = true;
				document.getElementById("passwordDisplayed").disable = true;
				document.getElementById("passwordDisplayed").style.backgroundColor = "#D4D0C8";
			}
			
			function enablePasswordInput()
			{
				document.getElementById("passwordDisplayed").disable = false;
				document.getElementById("passwordDisplayed").readOnly = false;
				document.getElementById('passwordDisplayed').style.backgroundColor = "white";
			}
			
			function disableAllInput()
			{
				disableUserNameInput();
				disablePasswordInput();
			}
			
			function enableAllnecessaryInput()
			{
				enablePasswordInput();
				if(!isRelogin())
				{
					enableUserNameInput();	
					setTimeout(function() { document.getElementById('userName').focus(); }, 0);
				}
				else
				{
					readOnlyUserNameInput();
					setTimeout(function() { document.getElementById('passwordDisplayed').focus(); }, 0);
				}
			}
			
			function toLogin()
			{
			    location.href = "<?=portal_prefix_path()?>/Login/Login";
			}
			
			function isValidInput(form)
			{
				if(isCertAuth())
				{
					return true;
				}

				var passwordVal = form['passwordDisplayed'].value;
				var usernameVal = form['userName'].value;

				if(passwordVal == null || passwordVal == '' || usernameVal == null || usernameVal == '')
				{
					return false;
				}
					
				return true;
			}
			
			if (top.location != self.location)
	        {
	            top.location = self.location;
	        }

	        function formSubmit(dis)
	        {
				if(!isValidInput(dis))
				{
					document.getElementById('ErrorMsg').innerHTML   = '<span class="errorMessage">' + loginErrorMsg + '</span>';
					
					return false;
				}
				
				<?PHP //encrypting password and disabling the displayed password field so it won't be submitted?>
                encryptPasswordAndDisablePasswordDisplay(dis);
				document.getElementById("LoginButton").disabled = true;
				
				var locationHref = "LoginWithCert?selectedRealm="+encodeURIComponent(document.getElementById("selectedRealm").value);
				if (null != document.loginForm.LaunchSWS)
				{
					if (document.loginForm.LaunchSWS.checked)
					{
						locationHref += "&LaunchSWS=on";
					}
				}
				
				if(eval("<?=$snx_relogin?>")) {
					locationHref = "ReLoginWithCert?selectedRealm="+encodeURIComponent(document.getElementById("selectedRealm").value); }
				if(eval("<?=$portalpopup_relogin?>")) {
					locationHref = "ReLoginWithCert?selectedRealm="+encodeURIComponent(document.getElementById("selectedRealm").value); }
	
				if(!isCertAuth())
	            {
	                return true;
	            }
	            else
	            {
	                location.href = locationHref;
	                return false;
	            }
	        }
			<?
			if ($portalpopup_relogin && IsInsideSWS())
			{
				echo "try{window.resizeTo(800, 485);}catch(e){}";
			}
			?>
			
			// Get privously selected realm from cookie and set it as selected realm
			function initSelectedRealm()
			{
				var selectedRealm = getCookie('selected_realm');
				
				if(selectedRealm != null)
				{	
					//	Set selected realm
					var options = document.getElementById('selectedRealm').options;
					for (var i = 0; i < options.length; i++) 
					{
						if (options[i].value == selectedRealm) 
						{
							options[i].selected= true;
							break;
						}
					}
				}
			}
			
			function getSelectedRealm()
			{
				var selectedRealmIndex = document.getElementById('selectedRealm').selectedIndex;
				
				return realmsArr[selectedRealmIndex];
			}
		
			// Creates a javascript associate array (class really) from php class
			function initAvailableRealms()
			{
				<?php
					for($i = 0; $i < count($realmsArr); $i++)
					{
						$realmVarName = "realm_" . $i;
						echo $realmVarName . " = new Array();" . PHP_EOL;
						
						foreach($realmsArr[$i] as $key => $value)
						{
							echo $realmVarName . "['" . $key . "'] = " . phpVarToJavascriptVar($value) . ";" . PHP_EOL;
						}
						
						echo "realmsArr[" . $i . "]" . "=" .  $realmVarName . ";" . PHP_EOL;
					}
				?>
			}
			
			function isShowRealmsCombobox()
			{
				// Only one realm
				if(realmsArr.length < 2)
				{
					return false;
				}
				
				// relogin
				if(<?php echo isRelogin(); ?>)
				{
					return false;
				}
				
				return true;
			}
			
			// Display or hide the realm select option
			function initRealmsCombobox()
			{
				if(!isShowRealmsCombobox())
				{
					document.getElementById('loginOptionlabel').style.display = 'none';
					document.getElementById('selectedRealm').style.display = 'none';
				}
			}
			
			
			function isCertAuth()
			{
				var realm = getSelectedRealm();
				var authType = realm.m_type;
				
				// Certificate authentication method
				if(authType == <?php echo REALM_AUTHN_METHOD_CERTIFICATE; ?>)
				{
					return true;
				}
				
				if(authType == <?php echo REALM_AUTHN_METHOD_PASSWORD_OR_CERTIFICATE; ?> && 
				   document.getElementById('Certificate').checked)
				{
					return true;
				}
				
				return false;
			}
			
			function initRealms()
			{
				// Set selected realm from cookie
				initSelectedRealm();
				
				// init available realms
				initAvailableRealms();
				
				//	Update view
				updateRealmView();
				
				// Display or hide the realm select option
				initRealmsCombobox();
			}
			
			function handleRealmChange()
			{
				document.getElementById('ErrorMsg').innerHTML   = '';
				
				updateRealmView();
			}
			
			// Hides all the input fields and labels
			function clearLoginForm()
			{
				document.getElementById('userNameInputId').style.display = 'none';
				document.getElementById('passwordInputId').style.display = 'none';
				document.getElementById('loginPagePromptCell').style.display = 'none';
				
				document.getElementById('certificateRadio').style.display = 'none';
				document.getElementById('credentialsRadio').style.display = 'none';
				
				document.getElementById('userNameTd').className  = 'loginInput';
				document.getElementById('passwordTd').className  = 'loginInput';
			}
			
			function setSelectedRealmCookie(selectedRealmName)
			{
				var expireDate = new Date ();
				expireDate.setTime(expireDate.getTime() + (<? echo LANG_COOKIE_EXPIRATION_DAYS; ?> * 24 * 3600 * 1000));
				setCookie("selected_realm", selectedRealmName, expireDate, "/", null /*domain*/, true /*secure*/);
			}
			
			function setStyleDisplayTableRow(elementID)
			{
				try {
					document.getElementById(elementID).style.display = 'table-row';
				}
				catch (e) {
					document.getElementById(elementID).style.display = 'block';
				}	
			}
			
			function showUserPasswordForm()
			{
				setStyleDisplayTableRow('userNameInputId');
				setStyleDisplayTableRow('passwordInputId');
				setStyleDisplayTableRow('loginPagePromptCell');
				
				if(isShowRealmsCombobox())
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgInput';
				}
				else
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgInputNoRealms';
				}
				
				enableAllnecessaryInput();
			}
			
			function showCertificateForm()
			{
				setStyleDisplayTableRow('loginPagePromptCell');
				
				if(isShowRealmsCombobox())
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgNoInput';
				}
				else
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgNoInputNoRealms';
				}
			}
			
			function showCertificateOrUserPasswordForm()
			{
				setStyleDisplayTableRow('userNameInputId');
				setStyleDisplayTableRow('passwordInputId');
				setStyleDisplayTableRow('promptRow');
				setStyleDisplayTableRow('certificateRadio');
				setStyleDisplayTableRow('credentialsRadio');
				
				document.getElementById('userNameTd').className  = 'loginInputLeftMargin';
				document.getElementById('passwordTd').className  = 'loginInputLeftMargin';

				if(document.getElementById('Certificate').checked)
				{
					disableAllInput();
				}
				else
				{
					enableAllnecessaryInput();
				}
				
				if(isShowRealmsCombobox())
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgLegacy';
				}
				else
				{
					document.getElementById('ErrorMsg').className = 'ErrorMsgLegacyNoRealms';
				}
			}
			
			function updateRealmView()
			{
				var selectedRealm = getSelectedRealm();
				
				// Set selected realm cookie
				setSelectedRealmCookie(selectedRealm.m_name);
				
				// Clear login form
				clearLoginForm();
				
				// Update prompt
				document.getElementById('loginPagePrompt').innerHTML  = selectedRealm.m_authnInstructionMessage;
				
				// Adjust login form
				switch(selectedRealm.m_type)
				{
					case <?php echo REALM_AUTHN_METHOD_PASSWORD; ?>: // eUserPassword
						showUserPasswordForm();
					break;
					
					case <?php echo REALM_AUTHN_METHOD_CERTIFICATE; ?>: // eCertificate
						showCertificateForm();
					break;
					
					case <?php echo REALM_AUTHN_METHOD_PASSWORD_OR_CERTIFICATE; ?>: // eCertificateOrUserPassword
					default:
						showCertificateOrUserPasswordForm();
					break;
					
					
				}
				
				// Set caps detect position
				setCapsLockDiv('passwordTd', sCapsLockHeadline, sCapsLockMessage);
		
				// Show the login table once all visibility settings were set to avoid flickering.
				setStyleDisplayTableRow('loginContainerTable');
			}
			
			function showIcsExpired()
			{
				document.getElementById("LoginFormDiv").style.display="none";
				document.getElementById("icsExpired").style.display="block";
				
				<?PHP //empty username and passwordDisplayed fields. ?>
				document.getElementById("userName").value = "";
				document.getElementById("passwordDisplayed").value = "";			
			}
			
			<?	
			if (($passedIcsScan) && ($ICSSessionCookieExpiration>0))
			{ ?> 
					setTimeout ("showIcsExpired()", <?= $ICSSessionCookieExpiration ?>);
			<? } ?>		 
			function showTuring() {
				turing = document.getElementById("imgTuring");
				username = document.getElementById("userName").value;
				turing.src = "https://<pinsafe>:8443/proxy/SCImage?username=" + username;
			}
	    </script>
    </HEAD>
    <body topmargin="0" leftmargin="0" class="body_default" style="overflow: auto;" onload="initRealms();">
		<TABLE id="Table1" cellSpacing="0" cellPadding="0" height="100%" width="100%" border="0">
			<TR>
                <TD width="100%" height="100%" align="center" valign="middle">
					<TABLE id="Table2" style="background: url(<?=portal_prefix_path()?>/Login/images/background_card.png) no-repeat" cellSpacing="0" cellPadding="0" height="460" width="767" border="0">
                        <TR>
							<TD width="100%" height="35" valign="bottom">
								<TABLE id="Table3" cellSpacing="0" cellPadding="0" width="100%" border="0" style="padding-top:25px;">
                        			<TR>
			                            <TD width=200>
											<center>
											<a href="<?=$firmHref?>" style="padding-left:10px;">
												<?=company_logo_html_segment()?>
											</a>
											</center>
										</TD>
										
			                            <TD align="right" style="padding-right:25px;">
											<DIV id=product_name class="productName" style="padding-left:30px; padding-top:0px; width:500px; overflow: hidden;" align="right">
												<?=charset_htmlentities($PortalTitle)?>
											</DIV>
										</TD>
			                        </TR>
			                    </TABLE>
			                </TD>
			            </TR>
			            <TR>
			                <TD width="100%" height="100%">
			                    <table width="100%" height="100%" cellpadding="0" cellspacing="0" border="0" style="padding-left: 5px;">
			                        <tr>
									<td width=10>&nbsp;</td>
									<td width=226 id="LegalNotice" valign=top>
									<?
										if (0 < strlen($LegalBannerTitle) || 0 < strlen($LegalBannerText))
										{
									?>
											<table height=<?=$nLegalNoticeSpace?>><tr><td>&nbsp;</td></tr></table>
											<table cellpadding=1 cellspacing=1 width=226 style="background: #C4CED0; border: #000000 1px solid; font-size: 11px;" align="left">
												<tr>
													<td align="center">
														<div style="overflow: hidden;">
															<b> <?=$LegalBannerTitle?> </b>
														</div>
													</td>
												</tr>
												<tr>
													<td colspan=2>
														<div style="overflow: hidden;">
															<?=$LegalBannerText?> 
														</div>
													</td>
												</tr>
											</table>
									<?
										}
									?>
									
									</td>
									<td width=18>&nbsp;</td>
								
                                        <td align="left" style="padding-left: 0px; position: relative;" valign="top">
										<?php
										if (!$snx_relogin && !$portalpopup_relogin)//regular login page
										{
											if (isset($_COOKIE['snxstat']) and ($_COOKIE['snxstat']!=""))
											{
                                                $bIsApplet = false;
                                                if (isset($_COOKIE['snxstat_Applet']) and ($_COOKIE['snxstat_Applet']!=""))
                                                {
                                                    $bIsApplet = true;
                                                }

												$messageA = PRE_LOGIN_AGAIN_NEED_TO_CLOSE;
												$messageB = $bIsApplet? SSL_AC_STILL_OPEN_MESSAGE : SSL_STILL_OPEN_MESSAGE;
												$butValue = TRY_AGAIN;
												$butActin = "toLogin();";
												if (array_key_exists("opener", $_GET))
												{
													$messageA = TRY_TO_OPEN_WHILE_ALREADY_OPEN;
													$messageB = PORTAL_OPEN_MESSAGE;
													$butValue = CLOSE_WINDOW;
													$butActin = "javascript: window.close();";
												}
												?>
												<table cellpadding="0" cellspacing="0" border="0" width="306">
													<tr><td height="70"></td></tr>       
													<tr>
														<td height="190" valign="top" style="padding-top: 8px;">
															<span class="errorMessage">
																<?= $messageA ?>.
																<br>
																<?= $messageB ?>.
																<br><img src="<?=portal_prefix_path()?>/Login/pix.gif" border="0" height="5" />
                                                                <br>
                                                                <? if ($bIsApplet){?>
                                                                    <img src="<?=portal_prefix_path()?>/Login/images/BBWinThumb.JPG" border="1" />
                                                                <? }else{?>
                                                                    <img src="<?=portal_prefix_path()?>/Login/images/snx_tray.gif" border="1" />
                                                                <? }?>

															</span>
														</td>
													</tr>
						                            <tr>
						                                <td align="right">
															<input type="button" id="Login" NAME="Login" value="<?=$butValue?>" align="absmiddle" onClick="<?=$butActin?>" class="butt" style="padding-left:1px; padding-right:1px;">
						                                </td>
						                            </tr>
												</table>
												<?php
											}
											else
											{
												printLoginForm();
											}
										}
										else
										{
											printLoginForm();
										}
										?>
                            </td>
                        </tr>
                    </table>
                </TD>
            </TR>
       		<?php
                require_once("FooterCP.php");
            ?>
        </TABLE>
				</TD>
			</TR>
        </TABLE>
    </body>
	<script language='javascript'>
	<?php
		// the snx isn't running or this is a snx relogin
	if (!((isset($_COOKIE['snxstat']) and ($_COOKIE['snxstat']!=""))) && !$portalpopup_relogin)
	{
		if (array_key_exists("userName", $_POST) )
		{
			print 'document.getElementById("passwordDisplayed").focus();';
		}
		else
		{
			print 'document.getElementById("userName").focus();';
		}
	}
	else if($snx_relogin || $portalpopup_relogin)
	{
		if(getenv("CVPN_CERT_LOGIN")==1)
		{
			print 'document.getElementById("LoginButton").focus();';
		}
		else
		{
			print 'document.getElementById("passwordDisplayed").focus();';
		}
	}
	?>
	</script>
</html>
<?php

function printLoginForm()
{
	global $action;
	global $message;
	global $snx_relogin;
	global $portalpopup_relogin;
    global $isSWSEnabled;
    global $isSWSMandatory;
	global $realmsArr;
	
	$br = new Browser;

	//Try to retrieve VPID prefix.
	$vpid_prefix = "";
	if ((array_key_exists("VPID", $_REQUEST)) && ($_REQUEST['VPID'] != ""))
	{
		$vpid_prefix = $_REQUEST['VPID']."@";
	}
	elseif ((array_key_exists("vpid_prefix", $_POST)) && ($_POST['vpid_prefix'] != ""))
	{
		$vpid_prefix = $_POST['vpid_prefix'];
	}
	
			$MsgOutput = '';
		
			$session_id = get_session_id();
			if (""!=$message && NULL!=$message)
			{
				$MsgOutput = "<span class=\"errorMessage\">" . $message . "</span>";
			}
			else if (!( ($session_id == NULL) or ($session_id == "")) )
			{
				$timeOutMessage = SESSION_TIMEOUT;
				if($snx_relogin || $portalpopup_relogin) {
					$timeOutMessage = SESSION_ABOUT_TO_TIMEOUT;
				}
				$timeOutMessage = $timeOutMessage . "<br>" . PLEASE_SIGN_IN_AGAIN;

				$MsgOutput = '<span class="errorMessage"><?=$timeOutMessage?></span>';

			}
			$userName = getenv("CVPN_USER_NAME");
			$certLogin = getenv("CVPN_CERT_LOGIN");
			$bShowSWSCheckbox = $isSWSEnabled && $br->bIsWindows;
			$bForceSWS = $isSWSMandatory;  //Todo: read from admin + decide about being checked by default 

			$radioDisabled = "";
			$UNPW_Radio_Chk = "checked";
			$CERT_Radio_Chk = "";
			$User_Read_Only = "";
			$Pass_Read_Only = "";
			$bSWSChecked="";
			$sDisableSWSSelection = "";
	        $User_Class_Var	= "loginInput";
	        $Pass_Class_Var	= "loginInput";
	        $User_Label_Class_Var = "inputLabel";
	        $Pass_Label_Class_Var = "inputLabel";
	        $loginOptionsClass = "";
			$UNPW_Class_Var = "signInType";
			$CERT_Class_Var = "signInType";
			$SWS_Check_Class = "font-size: 12px;";
			global $locale;
			if ("ru_ru"==strtolower($locale))
			{
				$SWS_Check_Class = "font-size: 10px;";
			}
			$SWS_Check_Class = $SWS_Check_Class . "font-weight: bold;line-height: 18px;";
			
			if ($snx_relogin || $portalpopup_relogin)
			{
				$radioDisabled = "disabled";
				$User_Read_Only = "readonly";
		        $User_Class_Var = "loginInputDisabled";
		        $User_Label_Class_Var = "inputLabelDisabled";
		        $loginOptionsClass = "loginOptionsHidden";
				$bShowSWSCheckbox = false;

				if($certLogin==1)
				{
					$UNPW_Radio_Chk = "";
					$CERT_Radio_Chk = "checked";
					$Pass_Read_Only = "readonly";
					$Pass_Class_Var = "loginInputDisabled";
					$Pass_Label_Class_Var = "inputLabelDisabled";
					$userName		= "";
					$UNPW_Class_Var = "signInTypeDis";
				}
				else
				{
					$CERT_Class_Var = "signInTypeDis";
				}
			}
			else
			{
				if (array_key_exists("userName", $_POST))
				{
					$userName=charset_htmlentities($_POST["userName"]);
					$bSWSChecked=""; //An unchecked checkbox is not sent in the POST data
					if (array_key_exists("LaunchSWS", $_POST))
					{
						  if ("on"==$_POST["LaunchSWS"])
						  {
							  $bSWSChecked="checked";
						  }
					}
				}
				if ($bForceSWS)
				{
					$bSWSChecked="checked";
					$sDisableSWSSelection = "disabled";
				}
			}

?>
	<div id="loginContainer">
		<div id="LoginLeft">
			<form id="loginForm" name="loginForm" method="post" action="<?= $action ?>" onSubmit="return formSubmit(this);">
				<!-- Login container table -->
				<table id="loginContainerTable" cellpadding="0" cellspacing="0" border="0" style="display:none;">
					<!-- Login option combobox -->
					<tr id = "loginOptionTableRow" class = "<? echo $loginOptionsClass; ?>">
						<td class="loginInput" style="width:100%">
							<div class = "inputLabel">
								<label for="selectedRealm" id = "loginOptionlabel">
									<?php echo LOGIN_OPTION; ?>:
								</label>
							</div>
							<div>
								<select name="selectedRealm" id = "selectedRealm" class="loginInput" onchange = "handleRealmChange();">	
									<?php 
										//Iterate over all the realms and write the select code
										for($i = 0; $i < count($realmsArr); $i++) 
										{
											echo "<option value='" . $realmsArr[$i]->m_name ."'>" . $realmsArr[$i]->m_displayName . "</option>" . PHP_EOL;
										}
									?>
								</select>
							</div>
						 </td>
					 </tr> <!-- loginOptionTableRow -->
					<!-- Input fields container -->
					<tr class="inputFieldsContainer">
						<td class="inputFieldsContainer" style="height: 100%;">
							<table id="inputFieldsTable" cellpadding="0" cellspacing="0" border="0" class="inputFieldsTable">
								<!-- Prompt message -->
								<tr id = "promptRow">
									<td id = "loginPagePromptCell" class = "secTitleBold" colspan = "1">
										<div id = "loginPagePrompt" class = "textBox secTitleBold">
										</div>
									</td>
								</tr>

								<!-- Standard input radio -->
								<tr id = "credentialsRadio">
									<td colspan="1" valign="middle" class="<?=$UNPW_Class_Var?>" style="padding-bottom:10px; padding-top:0px;">
										<input type="radio" name="loginType" id="Standard" value="Standard" style="margin: 0px 3px 0px 0px;" <?=$radioDisabled?> <?=$UNPW_Radio_Chk?> onclick="enableAllnecessaryInput();">							
										<label for="Standard"><?= STANDARD_SIGN_IN ?></label>
									</td>
								</tr>
						
								<!-- User name -->
								<tr id = "userNameInputId">
									<td id="userNameTd" class="loginInput">
										<div class = "<? echo $User_Label_Class_Var; ?>">
											<label for="userName" id="userNameLabel"><?= USER_NAME; ?></label>
										</div>
										<div>
											<input type="text" id="userName" name="userName" class="<?php echo $User_Class_Var ?>" autocomplete="off" <?=$User_Read_Only?> value="<?=$userName?>" onblur="showTuring();">
											<input type="hidden" id="vpid_prefix" name="vpid_prefix" value="<?php echo charset_htmlentities($vpid_prefix); ?>">
										</div>
									</td>
								</tr>
						
								<!-- Password -->
								<tr id = "passwordInputId">
									<? // Width style is set here for the caps detect position to ?>
									<td id="passwordTd" class="loginInput" style="width: 300px;">
										<div id="passwordContainer">
											<div class="<? echo $Pass_Label_Class_Var; ?>">
												<label for="passwordDisplayed" id = "passwordLabel"><?= PASSWORD; ?></label>
											</div>
											<div id ="passwordDisplayedDIV">
												<input type="password" id="passwordDisplayed" name="<?php echo $Pass_Class_Var; ?>" class="loginInput" colspan="1" autocomplete="off" onkeypress="capsDetect(arguments[0]);" onblur="HideCapsDiv(true);" <?= $Pass_Read_Only?>>
												<input type="hidden" id="password" name="password">
											</div>
										</div>
									</td>
								</tr>
								
								<!-- TURing image -->
								<tr>
									<td colspan="2" align="center">
										<input type="button" value="TURing" onclick="showTuring();"><br/>
										<img id="imgTuring" src="" />
									</td>
								</tr>
								
								<!-- Certificate radio -->
								<tr id = "certificateRadio">
									<td valign="middle" class="<?=$CERT_Class_Var?>"  style="padding-top:0px;">
										<div id = "certificateRadioDiv">
											<input type="radio" name="loginType" id="Certificate" value="Certificate" style="margin: 0px 3px 0px 0px;" <?=$radioDisabled?> <?=$CERT_Radio_Chk?> onclick="disableAllInput();">
											<label for="Certificate"><?= CERTIFICATE_SIGN_IN ?></label>
										</div>
									</td>	
								</tr>
								
								<? 	if ($bShowSWSCheckbox)
								{ ?>
								<!-- SWS checkbox -->
								<tr> 
									<td id="SWScheckBox" height="25px" valign="middle" class="<?=$CERT_Class_Var?>">
										<? 

											if ($sDisableSWSSelection)
											//ISW is mandatory
											{
											?>
												<table cellspacing=0 cellpadding=0 style="<?=$SWS_Check_Class?>;color : #1C49B2">
													<tr valign="top">											
														<td style="padding-left: 8px; height:40px"><?= LAUNCH_IN_SWS_MANDATORY ?></td>
													</tr>
												</table>
											<?
											}
											else
											{
										?>
											<table cellspacing=0 cellpadding=0 style="<?=$SWS_Check_Class?>">
												<tr valign="top">
													<td>
														<input type="checkbox" name="LaunchSWS" id="LaunchSWS" style="margin-left:0px; margin-right:3px" <?=$bSWSChecked?> <?=$sDisableSWSSelection?> >
													</td>
													<td>
														<label for="LaunchSWS" class="textBox secTitleBold"><?= LAUNCH_IN_SWS ?></label>
													</td>
												</tr>
											</table>
										<? } ?>
									 
									</td>
								</tr> <!-- SWS checkbox -->
								<? } ?>
								
								<!-- Submit button -->
								<tr>
									<td id="LoginButtonTD" align="right">
										<div id = "submitDiv">
											<input type="submit" id="LoginButton" NAME="Login" value="<?= SIGN_IN ?>" align="absmiddle" class="butt">
										</div>
									</td>
								</tr> <!-- submit button -->
								<tr height="0px">
									<td height="0px">
										<input type="hidden" name="HeightData">
									</td>
								</tr>
							</table> <!-- inputFieldsTable -->
						</td>  <!-- inputFieldsContainer -->
					</tr> <!-- inputFieldsContainer -->
				</table> <!-- loginContainerTable -->
			</form>	 <!-- loginForm  -->
		</div>	<!-- End of LoginLeft -->
		<div id="LoginRight">
			<div id="ErrorMsg">
				<?= $MsgOutput; ?>
			</div>
		</div>
		
		<div id="LoginBottom">
			<div id="Languages">
				<table>
					<tr>
						<?
						if ((!isset($snx_relogin) || !$snx_relogin )&& (!isset($portalpopup_relogin) || !$portalpopup_relogin))//Login page + a regular one
						{
							global $arLanguages;
							if (!IsInsideSWS())
							{
								?>
										<td colspan="1" width="60px" align="left" style="font-family: Sans-serif; color: black; font-size: 11px;font-weight: normal;">
											<label>Language:</label>
										</td>
										<td colspan="1" align="left" style="font-family: Sans-serif; color: black; font-size: 11px;font-weight: normal;">
										<SCRIPT LANGUAGE="JavaScript">
											<!--
												RenderLanguageSelectionCombo();
											//-->
											</SCRIPT>	
										</td>
								<?
							}
						}
						?>
					</tr>
				</table>

		</div> <!-- LoginBottom -->
	</div> <!-- LoginContainer -->
	<div id="icsExpired" width="306px" style="display:none; padding-top:100px">
		<table width="306px">
			<tr>
				<td class="signInType" style="padding-top:20px">
				<?= ICS_SESSION_EXPIRED ?>
				</td>
			</tr>
			<tr>
				<td align="right" style="padding-top:20px; padding-right:20px;">
					<form name="icsScanAgain" action="<?=portal_prefix_path()?>/Login/Login" method="post" >
						<input name="ScanAgainButton" id="ScanAgainButton" type="submit" value="<?= ICS_RESCAN ?>" class="butt"/>
					</form>
				</td>
			</tr>
		</table>
	</div>	
	<?php
}


?>
